// multsrDlg.cpp : implementation file
//

/*
  This example demonstrates the use of two SR structures from the same
  application.  Separate structures are used when making use of more than
  one subsystem on the same board or making use of more than one board.

  When more than one board is used, and they are associated with two different
  drivers, the SelectDriverLINX(instanceHandle)function must be used.

*/

#include "stdafx.h"
#include "multsr.h"
#include "multsrDlg.h"

#ifdef _DEBUG 
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMultsrDlg dialog

CMultsrDlg::CMultsrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMultsrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMultsrDlg)
	m_divalue = _T("");
	m_aivalue = _T("");
	m_deviceNum = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMultsrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultsrDlg)
	DDX_Control(pDX, IDC_BUTTON5, m_ai2Button);
	DDX_Control(pDX, IDC_BUTTON4, m_ctButton);
	DDX_Control(pDX, IDC_BUTTON3, m_aiButton);
	DDX_Control(pDX, IDC_BUTTON2, m_diButton);
	DDX_Text(pDX, IDC_DIVALUE, m_divalue);
	DDX_Text(pDX, IDC_AIVALUE, m_aivalue);
	DDX_Text(pDX, IDC_DEVICENUM, m_deviceNum);
	DDV_MinMaxUInt(pDX, m_deviceNum, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMultsrDlg, CDialog)
	//{{AFX_MSG_MAP(CMultsrDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnQuit)
	ON_BN_CLICKED(IDC_BUTTON2, OnReadCT)
	ON_BN_CLICKED(IDC_BUTTON3, OnReadAI)
	ON_BN_CLICKED(IDC_BUTTON4, OnInitCT)
	ON_BN_CLICKED(IDC_INIT, OnInit)
	ON_BN_CLICKED(IDC_BUTTON5, OnInitAI)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMultsrDlg message handlers

BOOL CMultsrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_SRCT=NULL;
	m_SRAI=NULL;
	m_driverInstanceCT=NULL;
	m_driverInstanceAI=NULL;

	return TRUE;  // return TRUE unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMultsrDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMultsrDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMultsrDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
}

void CMultsrDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	//close down DriverLINX
	if (m_driverInstanceCT != NULL)
	{
		SelectDriverLINX(m_driverInstanceCT);
		CloseDriverLINX(m_driverInstanceCT);
		m_driverInstanceCT = NULL;
	}


	if (m_SRCT != NULL)
	{
       delete m_SRCT;
	   m_SRCT=NULL;
	}
	
// do same for second Service Request
	if (m_driverInstanceAI != NULL)
	{
      SelectDriverLINX(m_driverInstanceAI);
      CloseDriverLINX(m_driverInstanceAI);
      m_driverInstanceAI = NULL;
	}


	if (m_SRAI != NULL)
	{
       delete m_SRAI;
	   m_SRAI=NULL;
	}
	
	OnOK();
	
}

void CMultsrDlg::OnReadCT() 
{
	// switch to driver for m_SRCT
	SelectDriverLINX(m_driverInstanceCT);
	m_SRCT->operation = STATUS;	
	if (DriverLINX(m_SRCT) == NoErr)
	{  // success
		m_divalue.Format("%d",m_SRCT->status.u.timerStatus.count);
		UpdateData(FALSE); // update the Dialog
	}
    else  // problem has occured
	{ showMessage(m_SRCT);}  // display the error message box
}

void CMultsrDlg::OnReadAI() 
{
	// if two different drivers has been loaded, then the SelectDriverLINX function
	// is necessary to load the correct mini-port driver for the hardware
	SelectDriverLINX(m_driverInstanceAI);

	if (DriverLINX(m_SRAI) == NoErr)
	{  // success
		float volts;
		int result;
		result = Code2Volts(m_deviceNum,AI,m_SRAI->status.u.ioValue,&volts);
		// Code2Volts function always assumes bipolar gain of 1 was used.
		// At other gains, this function will return incorrect data.
		// Need to factor in your gain or use the CONVERT opertation of
		// DriverLINX to have gain aware conversions.
		m_aivalue.Format("%8.3f",volts);
		UpdateData(FALSE); // update the Dialog
	}
    else  // problem has occured
	{
		showMessage(m_SRAI);
		MessageBox("ERROR in OnReadAI()","ERROR",MB_OK);
	}  // display the error message box

}

void CMultsrDlg::OnInitCT()	 
{

	// Initialize the Counter/Timer
	m_SRCT->device = m_deviceNum;
	m_SRCT->subsystem = CT;
	m_SRCT->mode = POLLED;
	m_SRCT->operation = START;
	m_SRCT->timing.typeEvent = RATEEVENT;
	m_SRCT->timing.u.rateEvent.channel = 1;  
	/*
		CT subsystem channels for KPCI-3108:
		0 = 32bit cascade (normally used for paced AI tasks)
		1 = single 16bit counter (CT0), input at pin 20/IP2
		2 = single 16bit counter (CT1), input at pin 2/IP3
		3 = single 16bit counter (CT2), driven by internal crystal only
    */
	m_SRCT->timing.u.rateEvent.mode = COUNT;        // 16 bit count mode
	m_SRCT->timing.u.rateEvent.clock = EXTERNAL;	// count signal applied at pin 20
	m_SRCT->timing.u.rateEvent.gate = NOCONNECT;  // no gating used
	m_SRCT->timing.u.rateEvent.period = 0;			// not used
	m_SRCT->timing.u.rateEvent.onCount = 0;			// not used 
	m_SRCT->timing.u.rateEvent.pulses = 0;			// repetitive counting
	m_SRCT->start.typeEvent = COMMAND;
	m_SRCT->stop.typeEvent = TCEVENT;
	m_SRCT->taskFlags = (NO_SERVICESTART | NO_SERVICEDONE);
	SelectDriverLINX(m_driverInstanceCT);
	if ( DriverLINX(m_SRCT) != 0)
		MessageBox("Keithley DriverLINX Counter Initialization Error.",
					"ERROR in CMultsrDlg::OnInitCT()",MB_OK);

	m_diButton.EnableWindow(TRUE);
	m_ctButton.EnableWindow(FALSE);
}


void CMultsrDlg::OnInitAI() 
{
	// Initialize the Analog Input
	// if two different drivers has been loaded, then the SelectDriverLINX function
	// is necessary to load the correct mini-port driver for the hardware
	SelectDriverLINX(m_driverInstanceAI);
	m_SRAI->device = m_deviceNum;
	m_SRAI->operation=START;
	m_SRAI->subsystem=AI;
	m_SRAI->mode=POLLED;
	m_SRAI->channels.nChannels=1;  // only one channel will be used
	m_SRAI->channels.chanGain[0].channel=0;  // the channel will be chan 0
	m_SRAI->channels.chanGain[0].gainOrRange = 
		Gain2Code(m_deviceNum,AI,-1);	// negative means bipolar; use + for unipolar
										// one means gain of 1
	m_SRAI->status.typeStatus=IOVALUE;

    m_ai2Button.EnableWindow(FALSE);
	m_aiButton.EnableWindow(TRUE);
}


void CMultsrDlg::OnInit() 
{
/*
	This example was written for KPCI-3108 or KPCI-3107.
	It was tested in Win2K SP1 with DriverLINX version 3108-850A04.0.0.1
	using Microsoft VC++ 6 Standard Edition

    This example uses two Service Request structures so that two
	tasks can independendently operate:  one does single value (polled)
	input from analog input channel 0;  the other does event counting.
*/


	// pass in driver name to avoid the OpenDriverLINX Dialog
	m_driverInstanceCT=OpenDriverLINX(m_hWnd,"kpci3108"); 
	m_driverInstanceAI=OpenDriverLINX(m_hWnd,"kpci3108"); 
	/*
		this example loads the same driver for each driver instance, but
		this does not have to be the case (if using two different boards for example)

    */
	// allocate the SR structures
	m_SRCT=(DL_ServiceRequest*) new DL_ServiceRequest;  
	m_SRAI=(DL_ServiceRequest*) new DL_ServiceRequest;
	// init members of structures to zero
	memset(m_SRCT,0,sizeof(DL_ServiceRequest));
	memset(m_SRAI,0,sizeof(DL_ServiceRequest));

	// need to bring in the Device Number from the entry box on the dialog
	UpdateData(TRUE);  // updates our variables such as m_deviceNum

	// initialize first SR (CT)
	DL_SetServiceRequestSize(*m_SRCT);
	m_SRCT->operation=INITIALIZE;
	m_SRCT->device=m_deviceNum;		// get device number from edit box on the dialog
	m_SRCT->mode=OTHER;
	m_SRCT->subsystem=DEVICE;
	m_SRCT->hWnd=m_hWnd;
	SelectDriverLINX(m_driverInstanceCT);  // select the driver instance loaded for our CT task
	if (DriverLINX(m_SRCT) == NoErr)
		m_ai2Button.EnableWindow(TRUE);
		else
		showMessage(m_SRCT);

	// initialize the second SR (AI)
	DL_SetServiceRequestSize(*m_SRAI);
	m_SRAI->operation=INITIALIZE;
	m_SRAI->device=m_deviceNum;	
	m_SRAI->mode=OTHER;
	m_SRAI->subsystem=DEVICE;
	m_SRAI->hWnd=m_hWnd;
	SelectDriverLINX(m_driverInstanceAI);
	if (DriverLINX(m_SRAI) == NoErr)
		m_ctButton.EnableWindow(TRUE);
	else
		showMessage(m_SRAI);
	
	CWnd::SetActiveWindow();  // set focus back to our dialog
}

